Test_Motors = class()

function Test_Motors:init()
    self.title = "motors"
end

function Test_Motors:setup()
    local minSide = math.min(WIDTH, HEIGHT)
    self.unit = minSide * 0.1
    self.lab = PhysicsLab()   
    local ground = self.lab:makePetrieDish()
    local carFriction = self.unit * 0.5
    local carSizeBase = WIDTH * 0.03
    local base, base1_5x, base2x, base2_5x, base3x, base4x, base5x = carSizeBase, carSizeBase * 1.5, carSizeBase * 2, carSizeBase * 2.5, carSizeBase * 3, carSizeBase * 4, carSizeBase * 5

    self.car = self.lab:polygonAt(base5x*-1, base, {vec2(base5x*-1,base*-1), vec2(base5x,base*-1), vec2(base5x,base), vec2(base3x,base),vec2(base2_5x,base2_5x),vec2(base2_5x*-1,base2_5x),vec2(base3x*-1,base)})
    self.car.position = vec2(WIDTH/2, base5x)
    self.car.friction = carFriction
    
    --setting maxTorque controls how fast the car can go
    local maxTorque = carSizeBase * 8
    local leftWheel = self.lab:circleAt(WIDTH/2 - base3x, base4x, base2x) 
    leftWheel.friction = carFriction
    self.leftJoint = self.lab:motorizedJoint(leftWheel, self.car, maxTorque)

    local rightWheel = self.lab:circleAt(WIDTH/2 + base3x, base4x, base1_5x)    
    rightWheel.friction = carFriction
    self.rightJoint = self.lab:pointThatTwoBodiesRevolveAround(rightWheel.x, rightWheel.y, self.car, rightWheel)

    
    for y = base5x * 1.25, base5x * 4, base3x do
        self.lab:boxAt(WIDTH*0.8, y, base3x, base3x)
        self.lab:boxAt(WIDTH*0.2, y, base3x, base3x)
    end
    
    print("The left wheel and the car share a motorized joint. Touch to the left or right of the car to move it.\n\nPhysicsLab includes a function for setting up a basic motor.")
    
end


function Test_Motors:draw()
    self.lab:draw()
    
end

function Test_Motors:touched(touch)
    self.lab:touched(touch)
    -- Codea does not automatically call this method
    if touch.state == BEGAN or touch.state == MOVING then
        if touch.x > self.car.x then
            self.leftJoint.motorSpeed = self.unit * 9000
        else
            self.leftJoint.motorSpeed = self.unit * -9000
        end        
    elseif touch.state == ENDED then
        self.leftJoint.motorSpeed = 0
    end
end

function Test_Motors:collide(contact)
    self.lab:collide(contact)
end

function Test_Motors:cleanup()
    self.lab:clear()
    self.leftJoint = nil
    self.rightJoint = nil
end
